<!DOCTYPE html>
<html>

<head>
    <title>IPD</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 100px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .patient_info {
            margin-bottom: 10px;
        }

        .patient_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 0.5px solid #b4b4b4;
            font-size: 14px;
        }

        .hospital_info {
            margin-bottom: 10px;
        }

        .hospital_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 0.5px solid #b4b4b4;
            font-size: 13px;
        }

        .bed_info {
            margin-bottom: 10px;
        }

        .bed_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 0.5px solid #b4b4b4;
            font-size: 13px;
        }

        .nurse_info {
            margin-bottom: 10px;
        }

        .nurse_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 0.5px solid #b4b4b4;
            font-size: 13px;
        }

        .history {
            margin-top: 20px;
        }

        .button {
            border: 0.5px solid #b4b4b4;
            border-radius: 5px;
            padding: 5px;
            font-size: 15px;
            display: inline-block;
            margin: 5px;
        }

        .signature_info {
            margin-top: 60px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table patient_info">
                <tbody>
                    <tr>
                        <td width="20%"><b>Patient Name</b></td>
                        <td width="25%"><?php echo $patient->patient_name; ?></td>
                        <td width="15%"><b>Age</b></td>
                        <td width="20%"><?php echo floor((time() - strtotime($patient->dob)) / 31556926); ?>Y</td>
                        <td width="10%"><b>Gender</b></td>
                        <td width="15%"><?php echo $this->lang->line($patient->gender); ?></td>
                    </tr>
                    <tr>
                        <td><b>Guardian Name</b></td>
                        <td><?php echo $patient->guardian_name; ?></td>
                        <td><b>Marital Status</b></td>
                        <td colspan="3"><?php echo $this->lang->line($patient->marital_status); ?></td>
                    </tr>
                    <tr>
                        <td><b>Address</b></td>
                        <td><?php echo $patient->address; ?></td>
                        <td><b>Mobile</b></td>
                        <td colspan="3"><?php echo $patient->phone; ?></td>
                    </tr>
                </tbody>
            </table>

            <!-- Patient Info -->
            <table class="table">
                <tbody>
                    <tr>
                        <td width="75%">
                            <table class="table hospital_info">
                                <tbody>
                                    <tr>
                                        <td width="24%"><b>Patient ID</b></td>
                                        <td width="26%"><?php echo $patient->patient_unique_id; ?></td>
                                        <td width="24%"><b>IPD Reg.</b></td>
                                        <td width="26%"><?php echo $patient->registration_no; ?></td>
                                    </tr>
                                    <tr>
                                        <td><b>Date Of Admission</b></td>
                                        <td>
                                            <?php echo $patient->admission_date ? date('d/m/Y h:ia', strtotime($patient->admission_date)) : ''; ?>
                                        </td>
                                        <td><b>Date of Discharge</b></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td><b>Disease</b></td>
                                        <td><?php echo $this->lang->line($patient->disease); ?></td>
                                        <td><b>Case</b></td>
                                        <td><?php echo $patient->case; ?></td>
                                    </tr>
                                    <tr>
                                        <td width="24%"><b>Refd. By</b></td>
                                        <td colspan="3" style="font-size: 12px;">
                                            <?php
                                            if ($patient->doctor_id > 0 && !empty($patient->doctor_id)) {
                                                echo $patient->doctor . ', ' . $patient->specialist;
                                            } else {
                                                echo $this->lang->line('self');
                                            } ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="1%"></td>
                        <!-- Right Table -->
                        <td width="24%">
                            <table class="table bed_info">
                                <tbody>
                                    <tr>
                                        <td width="70%"><b>Bed/Cabin No</b></td>
                                        <td width="30%"><b>Signature</b></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo $patient->bed; ?></td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Particular Table -->

            <table class="table nurse_info">
                <tbody>
                    <tr>
                        <td width="40%"><b>Particular</b></td>
                        <td width="20%"><b>Time</b></td>
                        <td width="40%"><b>Name of duty nurse</b></td>
                    </tr>
                    <tr>
                        <td>Time of patient received</td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Time of treatment starting</td>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>

            <table>
                <tbody>
                    <td>
                        <b>Number of Extra Attendant </b>
                    </td>
                    <td>
                        <span style="display: block; width: 130px; height: 30px; border: 0.5px solid #b4b4b4;">&nbsp;</span>
                    </td>
                </tbody>
            </table>

            <!-- History of the patient -->
            <table class="table history" style="margin-top: 5">
                <tbody>
                    <tr style="border: 0.5px solid #b4b4b4; border-radius: 5px;">
                        <td valign="top" style="height: 110px;">
                            <b class="button">History of the patient</b>
                            <p style="text-align: justify; padding: 5px; margin: 0;">
                                <?php echo $patient->patient_history; ?>
                            </p>
                        </td>
                    </tr>
                    <tr style="height: 10px;">
                        <td>&nbsp;</td>
                    </tr>
                    <tr style="border: 0.5px solid #b4b4b4; border-radius: 5px;">
                        <td valign="top" style="height: 300px;">
                            <b class="button">Operation Note/Conservative Treatment</b>
                            <p style="text-align: justify; padding: 5px; margin: 0;">
                                <?php echo $patient->operation_note; ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>

            <table class="table signature_info">
                <tbody>
                    <tr>
                        <td width="80%">
                            <b>Prepared by: </b> <?php echo $patient->created_by; ?>
                        </td>
                        <td width="20%">
                            <b>Signature</b>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>